// uncloseai browser toy - content script
// Injects uncloseai.js into every web page to add the floating AI button

(function () {
  "use strict";

  const UNCLOSEAI_SCRIPT_URL = "https://uncloseai.com/uncloseai.js";
  const UNCLOSEAI_MARKER = "__uncloseai_injected__";

  // Prevent double injection
  if (window[UNCLOSEAI_MARKER]) return;
  window[UNCLOSEAI_MARKER] = true;

  function getStorageAPI() {
    if (typeof browser !== "undefined" && browser.storage) return browser.storage;
    if (typeof chrome !== "undefined" && chrome.storage) return chrome.storage;
    return null;
  }

  function injectUncloseai() {
    // Don't inject into extension pages, about: pages, or chrome:// pages
    if (
      window.location.protocol === "chrome-extension:" ||
      window.location.protocol === "moz-extension:" ||
      window.location.protocol === "safari-web-extension:" ||
      window.location.protocol === "about:" ||
      window.location.protocol === "chrome:"
    ) {
      return;
    }

    // Check if already injected by the site itself
    const existing = document.querySelector(
      'script[src*="uncloseai.js"], script[src*="uncloseai.com/uncloseai.js"]'
    );
    if (existing) {
      console.log("uncloseai-browser-toy: uncloseai.js already present on page, skipping injection.");
      return;
    }

    const script = document.createElement("script");
    script.src = UNCLOSEAI_SCRIPT_URL;
    script.type = "module";
    script.dataset.source = "uncloseai-browser-toy";

    script.onload = function () {
      console.log("uncloseai-browser-toy: uncloseai.js injected successfully.");
    };

    script.onerror = function () {
      console.warn("uncloseai-browser-toy: failed to load uncloseai.js from CDN.");
    };

    (document.head || document.documentElement).appendChild(script);
  }

  function init() {
    const storage = getStorageAPI();

    if (!storage) {
      // No storage API available — inject unconditionally
      injectUncloseai();
      return;
    }

    storage.local.get(["enabled"], function (result) {
      // Default to enabled
      const enabled = result.enabled !== false;
      if (enabled) {
        injectUncloseai();
      } else {
        console.log("uncloseai-browser-toy: extension disabled, skipping injection.");
      }
    });
  }

  // Run when DOM is ready
  if (document.readyState === "loading") {
    document.addEventListener("DOMContentLoaded", init);
  } else {
    init();
  }
})();
