// uncloseai browser toy - background/service worker
// Handles extension lifecycle and icon badge

(function () {
  "use strict";

  function getStorageAPI() {
    if (typeof browser !== "undefined" && browser.storage) return browser.storage;
    if (typeof chrome !== "undefined" && chrome.storage) return chrome.storage;
    return null;
  }

  function getRuntimeAPI() {
    if (typeof browser !== "undefined" && browser.runtime) return browser.runtime;
    if (typeof chrome !== "undefined" && chrome.runtime) return chrome.runtime;
    return null;
  }

  function getActionAPI() {
    if (typeof browser !== "undefined" && browser.browserAction) return browser.browserAction;
    if (typeof chrome !== "undefined" && chrome.action) return chrome.action;
    if (typeof chrome !== "undefined" && chrome.browserAction) return chrome.browserAction;
    return null;
  }

  function updateBadge(enabled) {
    const action = getActionAPI();
    if (!action) return;

    if (action.setBadgeText) {
      action.setBadgeText({ text: enabled ? "" : "OFF" });
    }
    if (action.setBadgeBackgroundColor) {
      action.setBadgeBackgroundColor({ color: enabled ? "#4caf50" : "#999" });
    }
  }

  // Set default state on install
  const runtime = getRuntimeAPI();
  if (runtime && runtime.onInstalled) {
    runtime.onInstalled.addListener(function () {
      const storage = getStorageAPI();
      if (storage) {
        storage.local.set({ enabled: true });
      }
      updateBadge(true);
    });
  }

  // Listen for storage changes to update badge
  const storage = getStorageAPI();
  if (storage && storage.onChanged) {
    storage.onChanged.addListener(function (changes) {
      if (changes.enabled) {
        updateBadge(changes.enabled.newValue !== false);
      }
    });
  }

  // Initialize badge on startup
  if (storage) {
    storage.local.get(["enabled"], function (result) {
      updateBadge(result.enabled !== false);
    });
  }
})();
