// uncloseai browser toy - popup script

(function () {
  "use strict";

  function getStorageAPI() {
    if (typeof browser !== "undefined" && browser.storage) return browser.storage;
    if (typeof chrome !== "undefined" && chrome.storage) return chrome.storage;
    return null;
  }

  const toggle = document.getElementById("toggle-enabled");
  const statusDot = document.getElementById("status-dot");
  const statusText = document.getElementById("status-text");

  function updateUI(enabled) {
    toggle.checked = enabled;
    if (enabled) {
      statusDot.classList.add("active");
      statusText.textContent = "Active";
    } else {
      statusDot.classList.remove("active");
      statusText.textContent = "Disabled";
    }
  }

  // Load saved state
  const storage = getStorageAPI();
  if (storage) {
    storage.local.get(["enabled"], function (result) {
      const enabled = result.enabled !== false;
      updateUI(enabled);
    });
  }

  // Handle toggle
  toggle.addEventListener("change", function () {
    const enabled = toggle.checked;
    updateUI(enabled);

    if (storage) {
      storage.local.set({ enabled: enabled });
    }
  });
})();
